<?php
//
// Recommended way to include parent theme styles.
//  (Please see http://codex.wordpress.org/Child_Themes#How_to_Create_a_Child_Theme)
//  
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array('parent-style')
    );
}
//
// Your code goes below
//

/* 
 *  Divi WordPress Theme and WooCommerce plugin
 *  Make the Add To Cart buttons appear on the WooCommerce shop page. 
 */
 
add_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 20 );

/**
 * Overide WooCommerce additional order special notes
 *
**/
// Hook in
add_filter( 'woocommerce_checkout_fields' , 'custom_override_checkout_fields' );

// Our hooked in function - $fields is passed via the filter!
function custom_override_checkout_fields( $fields ) {
     $fields['order']['order_comments']['placeholder'] = 'Please add any special requirements for your order such as name on cake, etc..';
     $fields['order']['order_comments']['label'] = 'Special Requirements for your Order';
     return $fields;
} 

/**
 * Function adds a BCC header to emails that match our array
 * 
 * @param string $headers The default headers being used
 * @param string $object  The email type/object that is being processed
 */
function add_bcc_to_certain_emails( $headers, $object ) {
	// email types/objects to add bcc to
	$add_bcc_to = array(
		'new_order',		// New Orders
		'cancelled_order',		// Cancelled Orders
		'failed_order',		// Failed Orders
		'customer_processing_order',	// Customer Processing order from WooCommerce
		);
	// if our email object is in our array
	if ( in_array( $object, $add_bcc_to ) ) {
		// change our headers
		$headers = array( 
			$headers,
			'Bcc: Webmaster <twtull@gmail.com>' ."\r\n",
			);
	}
	return $headers;
}
add_filter( 'woocommerce_email_headers', 'add_bcc_to_certain_emails', 10, 2 );
